#!/bin/bash
# Add GL.removeLogoByAbbr() call to all GL-based JSX files

files=(
  "batch_ScoreAnimation2-FG-logospin.jsx"
  "batch_ScoreAnimation2-FG-logospin-CFB.jsx"
  "batch_ScoreAnimations2-TD.jsx"
  "batch_ScoreAnimations2-TD-CFB.jsx"
  "batch_HomeRun_3.jsx"
  "batch_RunScored_3.jsx"
  "batch_Homerun_H123.jsx"
  "batch_RunScored_H123.jsx"
  "batch_GOAL_Animation_1.jsx"
  "batch_ScoreAnimations1-FG.jsx"
)

for file in "${files[@]}"; do
  if [[ -f "$file" ]]; then
    # Check if cleanup already added
    if grep -q "removeLogoByAbbr" "$file"; then
      echo "✓ $file - already has cleanup"
    else
      # Find the line with GL.rqRenderTo and add cleanup after the closing brace
      # This is a simple approach - adds cleanup after the render block
      sed -i.bak '/GL\.rqRenderTo.*paths\.file/a\
    }\
\
    // Clean up logo from project after render\
    var removed = GL.removeLogoByAbbr(t.abbr);\
    if (removed > 0) $.writeln("Removed " + removed + " logo(s) for " + t.abbr);' "$file"
      echo "✓ $file - added cleanup"
    fi
  fi
done

echo ""
echo "Done! Review changes and delete .bak files when satisfied."
